@extends('admin.layout.template')
@section('title', 'Teams')
@section('content')

<div class="page-content">
    <div class="container-xxl">
        <div class="row">
            <div class="col-lg-12">

                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1">
                            <iconify-icon icon="solar:users-group-rounded-bold-duotone" class="text-primary fs-20"></iconify-icon>
                            Add Team
                        </h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('add-team') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-4">
                                    <label class="form-label">Team Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="e.g. India" required>
                                </div>
                                <div class="col-lg-4">
                                    <label class="form-label">Short Name</label>
                                    <input type="text" name="short_name" class="form-control" placeholder="e.g. IND">
                                </div>
                                <div class="col-lg-4">
                                    <label class="form-label">Flag / Logo</label>
                                    <input type="file" name="photo" class="form-control">
                                </div>
                            </div>
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-success">Save</button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle table-hover" id="teamTable">
                                <thead class="bg-light-subtle">
                                    <tr>
                                        <th>SL.NO</th>
                                        <th>Team</th>
                                        <th>Short</th>
                                        <th>Flag</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<script>
$(function(){
    $('#teamTable').DataTable({
     processing: true,
    serverSide: true,
    ajax: "{{ route('get-teams') }}",
    columns: [
        { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
        { data: 'name', name: 'name' },
        { data: 'short_name', name: 'short_name' },
        {
            data: 'flag',
            name: 'flag',
            render: function(data) {
                return data ? `<img src="${data}" alt="flag" width="40">` : '';
            }
        },
        { data: 'action', name: 'action', orderable: false, searchable: false },
    ]
    });

    $(document).on('click', '.deleteTeam', function(){
        let id = $(this).data('id');
        Swal.fire({
            title: 'Delete?',
            text: 'Are you sure?',
            icon: 'warning',
            showCancelButton: true,
        }).then((res)=>{
            if(res.isConfirmed){
                $.ajax({
                    url: "{{ url('delete-team') }}/"+id,
                    type: 'DELETE',
                    data:{_token:'{{csrf_token()}}'},
                    success: function(r){
                        Swal.fire('Deleted!', r.success, 'success');
                        $('#teamTable').DataTable().ajax.reload();
                    }
                });
            }
        });
    });
});


</script>
@endsection
